// GLOBALE KONSTANTEN.
var ____KUNDE = 'carharttwip';

const google_muster = {
	'ausschließend': {
		encode: function(str) {return '-'+str;},
		decode: /^\-(.*?)((\s)+(.*)|$)/,
	},
	'weitgehend passend': {
		encode: function(str) {return '+'+str;},
		decode: /^\+(.*?)((\s)+(.*)|$)/,
	},
	'passend': {
		encode: function(str) {return '\"'+str+'\"';},
		decode: /^\"(.*?)\"((\s)+(.*)|$)/,
	},
	'genau passend': {
		encode: function(str) {return '['+str+']';},
		decode: /^\[(.*?)\]((\s)+(.*)|$)/,
	},
	'id': {
		encode: function(str) {return str;},
	},
};


const adset_muster = {
	encode: function(name) {
		return name.pre+' | '+name.id+' - '+name.post;
	},
	decode: function(name) {
		var regex = /^\s*(|(?!(\s|\|)).|(?!(\s)).(\s|.)*(?!(\s|\|)).)\s*\|\s*(|(?!(\s|\-)).|(?!(\s)).(\s|.)*(?!(\s|\-)).)\s*(\-|)\s*(EX|MB)\s*$/;
		var pre = '';
		var id = '';
		var post = '';
		var cond = false;
		name.replace(regex,function(_,$0,_,_,_,_,$1,_,_,_,_,_,$2) {	// 1, 6, 12.
			pre = $0;
			id = $1;
			post = $2;
			cond = true;
		});
		if(!cond) {
			regex = /^\s*(|(?!(\s|\|)).|(?!(\s)).(\s|.)*(?!(\s|\|)).)\s*\|\s*(|(?!(\s)).|(?!(\s)).(\s|.)*(?!(\s)).)\s*$/;
			name.replace(regex,function(_,$0,_,_,_,_,$1) { // 1, 6
				pre = $0;
				id = $1;
				cond = true;
			});
		}
		if(!cond) {
			regex = /^\s*(|(?!(\s|\-)).|(?!(\s)).(\s|.)*(?!(\s|\-)).)\s*(\-|)\s*(EX|MB)\s*$/;
			name.replace(regex,function(_,$0,_,_,_,_,_,$2) { // 1, 7
				pre = $0
				post = $2;
				cond = true;
			});
		}
		if(!cond) {
			regex = /^\s*(|(?!(\s)).|(?!(\s)).(\s|.)*(?!(\s)).)\s*$/;
			name.replace(regex,function(_,$0) {
				pre = $0
				cond = true;
			});
		}
		return {pre:pre, id:id, post:post};
	},
};

// SORTIERENOPTIONEN
const sortcampaignnamen = function(a,b) {
	var regex = /^\s*(.*\S|)\s*$/;
	var aa = a.replace(regex, function(_,$0) {return $0;}).split(/\s*\-\s*/);
	var bb = b.replace(regex, function(_,$0) {return $0;}).split(/\s*\-\s*/);
	var n = aa.length;
	var m = bb.length;
	if(!(n==m)) {
		return n-m;
	} else {
		var d = 0;
		var i = 0;
		if(n > 2) i++;
		var cond = true;
		while(i<n && cond) {
			d = aa[i].localeCompare(bb[i]);
			cond = (d == 0);
			i++;
		}
		if(cond) d = aa[0].localeCompare(bb[0]);
		return d;
	}
};

const alphabetisch = function(a,b) {
	var aa = a.toLowerCase();
	var bb = b.toLowerCase();
	return aa.localeCompare(bb);
};
const numerisch = function(x,y) {
	return x-y;
};
const blocklexikalisch = function(x,y) {
	var m = x.length;
	var xx = x.join(' ');
	var n = y.length;
	var yy = y.join(' ');
	var cond = xx.localeCompare(yy);
	if(!cond) {
		return -(m-n);
	} else {
		return cond;
	}
};
const partitionlexikalisch = function(x,y) {
	var m = 0;
	var xx = [];
	x.forEach(function(el,i) {
		xx.push(el.join(' '));
		m += el.length;
	});
	xx = xx.join('\n');
	var n = 0;
	var yy = [];
	y.forEach(function(el,i) {
		yy.push(el.join(' '));
		n += el.length;
	});
	yy = yy.join('\n');
	var cond = xx.localeCompare(yy);
	if(!cond) {
		return -(m-n);
	} else {
		return cond;
	}
};
const uebereinstimmen = {
	'ignorecase': function(u,v) {
		var cond = false;
		if(u.length == v.length) {
			cond = true;
			var n = u.length;
			var i = 0;
			while(cond && i<n) {
				cond = (u[i].toLowerCase() == v[i].toLowerCase());
				i++;
			}
		}
		return cond;
	},
	'casesensitive': function(u,v) {
		var cond = false;
		if(u.length == v.length) {
			cond = true;
			var n = u.length;
			var i = 0;
			while(cond && i<n) {
				cond = (u[i] == v[i]);
				i++;
			}
		}
		return cond;
	},
};